<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/db.php';

if (!isset($_SESSION['memberId'])) {
    header("Location: home");
    exit;
}

$user_id = $_SESSION['memberId'];
$userCheckSite = $DB->prepare("SELECT * FROM users WHERE id = ?");
$userCheckSite->execute(array($user_id));
$userChk = $userCheckSite->fetch(PDO::FETCH_ASSOC);

$search = isset($_POST['search']) ? $_POST['search'] : '';

$companyQuery = $DB->prepare("
    SELECT * 
    FROM companies 
    WHERE name LIKE ? 
        OR phone LIKE ? 
        OR email LIKE ? 
        OR company LIKE ?
");
$searchTerm = "%{$search}%";
$companyQuery->execute([$searchTerm, $searchTerm, $searchTerm, $searchTerm]);
$companies = $companyQuery->fetchAll(PDO::FETCH_ASSOC);


?>

<?php foreach ($companies as $companyData): ?>
<tr class="odd">
<td class="sorting_1">
                                            #<?=$companyData['id']?></a>
                                        </td>
										<td>
                                        <h6><?=$companyData['company']?></h6>
                                        </td>
                                        <td>
                                        <h6><?=$companyData['name']?></h6>
                                        </td>
                                        <td>
                                        <?php if (!empty($companyData['email'])): ?>
                                            <h6><?=$companyData['phone']?> / <?=$companyData['email']?></h6>
                                        <?php else: ?>
                                            <h6><?=$companyData['phone']?></h6>
                                        <?php endif; ?>
                                        </td>

                                        <td>
                                        <h6><?=$companyData['address']?></h6>
                                        </td>
                                        <td>
                                        <h6>
                                            <?php
                                            if ($companyData['date2'] == '0000-00-00') {
                                                echo '';
                                            } else {
                                                echo $companyData['date2'];
                                            }
                                            ?>
                                        </h6>
</td>

                                        <td>
                                        <h6><?=$companyData['date']?></h6>
                                        </td>
                                        <td>
										<div class="d-flex">
										<?php if ($userChk['pcompanyEdit'] == '1' || $userChk['isAdmin'] == '1') { ?>						
                                        <a href="company/<?=$companyData['id']?>" class="btn btn-primary shadow btn-xs sharp me-1"><i data-feather="edit-2" class="feather-icon-edit"></i></a>
										<?php } ?>
                                        <?php if ($userChk['pcompanyDell'] == '1' || $userChk['isAdmin'] == '1') { ?>
                                        <a id="companyDell" companyID="<?=$companyData['id']?>" class="companyDell btn btn-danger shadow btn-xs sharp"><i data-feather="trash-2" class="feather-icon-trash"></i></a>
                                        <?php } ?>                    
                                    </div>
	</div></td>
</tr>
<?php endforeach; ?>
<script>feather.replace();</script>
